function [subcoords,subdataraw]=plotandselect(Aproj_raw,coords,rawdata);
%This program allows you to isolate a specific subpopulation of mass
%spectra for further analysis.  Here you will make a cluster plot, use a
%lasso tool to select a sub-group of points, and then visualize where the
%points you selected are located within the sample.  This will not give you
%a heat map of specific principal components, rather it will only be an
%indication of which pixels you keep for further analysis.  The ideal point
%of this program is to isolate relevant pixels from garbage.  The
%heat map graph shows isolated pixels in white, discarded pixels in grey,
%and pixels that were never included in the MALDI image as black.

%INPUTS
%Aproj_raw - PC coordinates matrix
%coords - a matrix containing the pixel coordinates of each mass spectrum.
%rawdata - the matrix containing your raw (possibly trimmed and/or
%downsampled and/or Gaussian smoothed) data.

%OUTPUTS
%subcoords - the MALDI image XY coordinates of the subsection of data you
%select

%subfinaldata - the acutal MALDI ms spectra of the subsection of data you
%select.  subcoords and subfinaldata are correlated such that the nth row
%of subfinaldata is the mass spectrum located at the XY position listed on
%the nth row of subcoords



%Plot your PC data.  By default, this plots the first and second principal
%components.  To change this, replace x and y below:
x=1;
y=2;
figure
plot(Aproj_raw(x,:),Aproj_raw(y,:),'*')
set(gca,'FontSize',16)
set(gcf, 'color', 'white');

eval(['clear data', num2str(x), ';'])

xlabel('PC 1','FontSize',16)
ylabel('PC 2','FontSize',16)
set(gca,'XTick',[])
set(gca,'YTick',[])

%Use this command to generate a lasso to select a subsection of points.
[indexes,xselect,yselect] = selectdata('selectionmode','lasso');
clear xselect yselect

[a,b]=size(indexes);
%Isolate the coordinates of the points you lasso-ed.
for x=1:a
    subcoords(x,:)=coords(indexes(x),:);
end
clear x
for x=1:a
    subdataraw(x,:)=rawdata(indexes(x),:);
end
clear a b ans x

%make an mage of what you are keeping.  I use twos for discarded pixels
rows=max(coords(:,1));
columns=max(coords(:,2));
image1=zeros(rows,columns);
[c,d]=size(coords);
for x=1:c
    image1(coords(x,1),coords(x,2))=5;
end
clear c d
[a,b]=size(subcoords);
for x=1:a
    image1(subcoords(x,1),subcoords(x,2))=11;
end
figure
imagesc(image1')
axis tight
colormap bone
set(gcf, 'color', 'white');
set(gca,'FontSize',16)
xlabel('X Coordinate','FontSize',16)
ylabel('Y Coordinate','FontSize',16)
set(gca,'ticklength',[0,0])

